/**********************************************************************************/
/* MyFirstDeviceDiver.h													*/
/**********************************************************************************/

/*define the different ioctl operations*/
#define op_NOP				0
#define op_CLEARALL			1
#define op_GETNUMOPS			2

#ifdef _BUILDING_MY_FIRST_DEVICE_DRIVER_

status_t
init_hardware (void);	/*called when the hardware is loaded	*/

status_t
init_driver (void);		/*called when the device is loaded	*/

void
uninit_driver (void);		/*called when driver is unloaded	*/

static status_t
my_device_open (const char *name, uint32 flags, void** cookie);

static status_t
my_device_read (void* cookie, off_t position, void *buf, size_t* num_bytes);

static status_t
my_device_write (void* cookie, off_t position, const void* buffer, size_t* num_bytes);

static status_t
my_device_control (void* cookie, uint32 op, void* arg, size_t len);

static status_t
my_device_close (void* cookie);

static status_t
my_device_free (void* cookie);

const char**
publish_devices();

device_hooks*
find_device(const char* name);

#endif //_BUILDING_MY_FIRST_DEVICE_DRIVER_